﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL
{
    /// <summary>
    /// Bazowe narzedzia liczace do wykorzystania w BO i BL
    /// </summary>
    public static class BasicUtility
    {
        /// <summary>
        /// Liczenie procentów
        /// </summary>
        /// <param name="Point"></param>
        /// <param name="MaxPoint"></param>
        /// <returns></returns>
        public static int PointPercent(int Point, int MaxPoint)
        {
            return MaxPoint == 0 ? 0 : Math.Min((Point * 100) / MaxPoint, 100);
        }

        public static int PointPercent(int? Point, int? MaxPoint)
        {
            if (Point.HasValue && MaxPoint.HasValue)
            {
                return PointPercent(Point.Value, MaxPoint.Value);
            }
            return 0;
        }

    }
}